#include <afxwin.h>
#include <string.h>
#include <malloc.h>
#include "LinkedList.h"


lpNamedRef g_pHList = NULL;

NamedRef::NamedRef()
{
  pParent = pChild = 0;
  pNext = 0;
}

NamedRef::NamedRef(const char* parent, const char* child, NamedRef* next)
{
  pParent = parent ? strdup(parent) : 0;
  pChild = child ? strdup(child) : 0;
  pNext = next;
}



NamedRef::~NamedRef()
{
  if (pParent)
    free(pParent);
  if (pChild)
    free(pChild);
  pNext = 0;
}


void AddFirst(lpNamedRef& head, const char* ParName, const char* ChldName)
{
  lpNamedRef pNode = new NamedRef(ParName, ChldName, head);
  head = pNode;
}


void AddLast (lpNamedRef& head, const char* ParName, const char* ChldName)
{
  lpNamedRef pNode = head;
  if (!pNode)
  {
    AddFirst(head, ParName, ChldName);
    return;
  }
  while (pNode->pNext)
    pNode = pNode->pNext;

  pNode->pNext = new NamedRef(ParName, ChldName, 0);
}


void DeleteList( lpNamedRef& head)
{
  while (head)
    DeleteFirst(head);
  head = NULL;
}

void DeleteFirst(lpNamedRef& head)
{
  if (!head)
    return;
  lpNamedRef pNode = head->pNext;
  delete head;
  head = pNode;
}


void DeleteLast( lpNamedRef& head)
{
  if (!head || !head->pNext)
    DeleteFirst(head);
  else
  {
    lpNamedRef pNode = head;
    while (pNode->pNext)
      pNode = pNode->pNext;
    delete pNode->pNext;
    pNode->pNext = 0;
  }
}


void DeleteNode( lpNamedRef& head, const char* ParName, const char* ChldName)
{
  if (!head)
    return;
  if (((!ParName && !head->pParent) ||
      (ParName && head->pParent && !strcmp(ParName, head->pParent))) &&
      ((!ChldName && !head->pChild) ||
      (ChldName && head->pChild && !strcmp(ChldName, head->pChild))))
  {
    DeleteFirst(head);
    return;
  }
  lpNamedRef pNode = head;
  while (pNode && pNode->pNext)
  {
    if (((!ParName && !pNode->pNext->pParent) ||
        (ParName && pNode->pNext->pParent && !strcmp(ParName, pNode->pNext->pParent))) &&
        ((!ChldName && !pNode->pNext->pChild) ||
        (ChldName && pNode->pNext->pChild && !strcmp(ChldName, pNode->pNext->pChild))))
    {
      lpNamedRef ptr = pNode->pNext->pNext;
      delete pNode->pNext;
      pNode->pNext = ptr;
    }
    pNode = pNode->pNext;
  }
}


void DeleteRef(  lpNamedRef& head, lpNamedRef ref)
{
  if (head == ref)
    DeleteFirst(head);
  else
  {
    lpNamedRef pNode = head;
    while (pNode && pNode->pNext)
    {
      if (pNode->pNext == ref)
      {
        lpNamedRef ptr = pNode->pNext->pNext;
        delete pNode->pNext;
        pNode->pNext = ptr;
      }
      pNode = pNode->pNext;
    }
  }
}


bool FindRef(lpNamedRef head, lpNamedRef pRef)
{
  lpNamedRef pNode = head;
  while (pNode)
    if (pNode == pRef)
      return true;
    else
      pNode = pNode->pNext;
  return false;
}


bool FindRef(lpNamedRef head, const char* ParName, const char* ChldName, lpNamedRef* ppRes)
{
  lpNamedRef pNode = head;
  while (pNode)
    if (((!ParName && !pNode->pParent) ||
        (ParName && pNode->pParent && !strcmp(ParName, pNode->pParent))) &&
        ((!ChldName && !pNode->pChild) ||
        (ChldName && pNode->pChild && !strcmp(ChldName, pNode->pChild))))
    {
      if (ppRes)
        (*ppRes) = pNode;
      return true;
    }
    else
      pNode = pNode->pNext;
  return false;
}


bool FindNextChild(lpNamedRef head, const char* ParName, const char* currChild, lpNamedRef* ppRes)
{
  lpNamedRef pNode = head;
  bool bCanReturn = (currChild == 0);
  while (pNode)
  {
    if ((!ParName && !pNode->pParent) ||
        (ParName && pNode->pParent && !strcmp(ParName, pNode->pParent)))
    {
      if (bCanReturn)
      {
        if (ppRes)
          (*ppRes) = pNode;
        return true;
      }
      else
        bCanReturn = ((!currChild && !pNode->pChild) ||
                      (currChild && pNode->pChild && !strcmp(currChild, pNode->pChild)));
    }
    pNode = pNode->pNext;
  }
  return false;
}


bool FindParent(lpNamedRef head, const char* ChildName, lpNamedRef* ppRes)
{
  lpNamedRef pNode = head;
  bool bCanReturn = (ChildName == 0);
  while (pNode)
    if ((!ChildName && !pNode->pChild) ||
        (ChildName && pNode->pChild && !strcmp(ChildName, pNode->pChild)))
    {
      if (ppRes)
        (*ppRes) = pNode;
      return true;
    }
    else
      pNode = pNode->pNext;
  return false;
}

bool HasChild(lpNamedRef head, const char* ParName)
{
  if (!head)
    return 0;
  long num = 0;
  lpNamedRef pNode = head;
  while (pNode)
    if ((ParName && pNode->pParent && !strcmp(ParName, pNode->pParent)))
      return true;
    else
      pNode = pNode->pNext;
  return false;
}


long CountChilds(lpNamedRef node)
{
  if (!node)
    return 0;
  long num = 0;
  lpNamedRef pNode = node;
  const char* parName = node->pParent;
  while (pNode)
    if ((!parName && !pNode->pParent) ||
        (parName && pNode->pParent && !strcmp(parName, pNode->pParent)))
      num++;
    pNode = pNode->pNext;
  return num;
}

long CountChilds(lpNamedRef head, const char* parName)
{
  if (!head)
    return 0;
  long num = 0;
  lpNamedRef pNode = head;
  while (pNode)
    if ((!parName && !pNode->pParent) ||
        (parName && pNode->pParent && !strcmp(parName, pNode->pParent)))
      num++;
    pNode = pNode->pNext;
  return num;
}

long CountAllChilds(lpNamedRef node)
{
  if (!node)
    return 0;
  long num = 0;
  lpNamedRef pNode = node;
  const char* parName = node->pParent;
  while (pNode)
    if ((!parName && !pNode->pParent) ||
        (parName && pNode->pParent && !strcmp(parName, pNode->pParent)))
      num+= 1 + CountAllChilds(pNode);
    pNode = pNode->pNext;
  return num;
}

long CountAllChilds(lpNamedRef head, const char* parName)
{
  if (!head)
    return 0;
  long num = 0;
  lpNamedRef pNode = head;
  while (pNode)
    if ((!parName && !pNode->pParent) ||
        (parName && pNode->pParent && !strcmp(parName, pNode->pParent)))
      num+= 1 + CountAllChilds(pNode);
    pNode = pNode->pNext;
  return num;
}


void MoveChildren(lpNamedRef head, const char* fromParent, const char* toParent)
{
  lpNamedRef pNode = head;
  while (pNode)
  {
    if ((!fromParent && !pNode->pParent) ||
        (fromParent && pNode->pParent && !strcmp(fromParent, pNode->pParent)))
    {
      if (pNode->pParent)
        free(pNode->pParent);
      pNode->pParent = (toParent) ? strdup(toParent) : 0;
    }
    pNode = pNode->pNext;
  }
}


void MoveNode(lpNamedRef head, const char* nodeName, const char* toParent)
{
  lpNamedRef pNode = head;
  while (pNode)
  {
    if (nodeName && pNode->pChild && !strcmp(nodeName, pNode->pChild))
    {
      if (pNode->pParent)
        free(pNode->pParent);
      pNode->pParent = (toParent) ? strdup(toParent) : 0;
    }
    pNode = pNode->pNext;
  }
}


bool IsDirectChild(lpNamedRef head, const char* ChildName, const char* ParName)
{
  if (!head)
    return false;
  lpNamedRef pNode = head;
  while (pNode)
  {
    if (ChildName && pNode->pChild && !strcmp(ChildName, pNode->pChild) &&
        (ParName && pNode->pParent && !strcmp(ParName, pNode->pParent) ||
         !ParName && !pNode->pParent))
      return true;
    else
      pNode = pNode->pNext;
  }
  return false;
}



bool IsIndirectChild(lpNamedRef head, const char* ChildName, const char* ParName)
{
  if (!head)
    return false;
  lpNamedRef pRef;
  const char* pName = ChildName;
  while (FindParent(head, pName, &pRef))
  {
    if ((!pRef->pParent && !ParName) ||
        (pRef->pParent && ParName && !strcmp(pRef->pParent, ParName)))
      return true;
    else
      pName = pRef->pParent;
  }
  return false;
}


